<!-- start Simple Custom CSS and JS -->
<script>
jQuery(document).ready(function($){
    $('.navigation li').on('click', function() {
        var target = $(this).data('control'); // Get number clicked

        // Remove active class from all buttons
        $('.navigation li').removeClass('active');
        // Add active class to clicked button
        $(this).addClass('active');

        // Remove active class from all images
        $('.images .item').removeClass('active');

        // Add active class to the corresponding image
        $('.images .item[data-count="' + target + '"]').addClass('active');
    });
});
</script>

<script>
document.addEventListener("DOMContentLoaded", function() {
  const jobItems = document.querySelectorAll(".job-item");

  jobItems.forEach(item => {
    item.addEventListener("click", function() {
      const info = this.querySelector(".hide-info-careers");
      const isActive = this.classList.contains("active");

      // First reset all items
      jobItems.forEach(i => {
        i.classList.remove("active");
        const inf = i.querySelector(".hide-info-careers");
        if (inf) inf.style.display = "none";
      });

      // If it wasn't active before, activate it now
      if (!isActive) {
        this.classList.add("active");
        if (info) info.style.display = "block";
      }
      // If it was active, it just closes (active removed above)
    });
  });
});
</script>



<!-- end Simple Custom CSS and JS -->
