/* 
 * Note, this does not auto-load, because it does not contain identifiable namespaces or module dependencies
 * 
 * For the beta, this is intentional. It will likely change with time
*/
jQuery(function($) {
    WPGMZA.Map.prototype.__fetchFeaturesViaREST = WPGMZA.Map.prototype.fetchFeaturesViaREST;

    WPGMZA.Map.prototype.fetchFeaturesViaREST = function(){
        if(typeof WPGMZA_CACHE !== 'undefined' && typeof WPGMZA_CACHE.markers !== 'undefined' && typeof WPGMZA_CACHE.markers.defer !== 'undefined'){
            /* Deferred loading */
            if(WPGMZA_CACHE.markers.defer.trim().length > 0){
                $.ajax(WPGMZA_CACHE.markers.defer.trim()).then((data) => {
                    if(data && data instanceof Object){
                        /* Repopulate the local cache now */
                        for(let cacheKey in data){
                            WPGMZA_CACHE.markers[cacheKey] = data[cacheKey];
                        }

                        if(typeof WPGMZA_CACHE.markers.data !== 'undefined'){
                            /* Deferred data loaded correctly */
                            this.fetchFeaturesViaCache();
                            WPGMZA_CACHE.markers.info.source = "defer-cache";
                        } else {
                            /* Something has gone wrong */
                            this.__fetchFeaturesViaREST();
                            WPGMZA_CACHE.markers.info.source = "rest";
                        }
                    }
                }).catch((error) => {
                    /* Something went wrong, use original function */
                    this.__fetchFeaturesViaREST();
                    WPGMZA_CACHE.markers.info = {};
                    WPGMZA_CACHE.markers.info.source = "rest";
                });
            } else {
                /* Cache is not ready yet, use original function */
                this.__fetchFeaturesViaREST();
                WPGMZA_CACHE.markers.info = {};
                WPGMZA_CACHE.markers.info.source = "rest";
            }
        } else {
            /* Localized loading */
            if(typeof WPGMZA_CACHE === 'undefined' || typeof WPGMZA_CACHE.markers === 'undefined' || typeof WPGMZA_CACHE.markers.data === 'undefined'){
                /* Run the original function - Missing cache localized data */
                this.__fetchFeaturesViaREST();
                WPGMZA_CACHE.markers.info.source = "rest";
            } else {
                /* Load from the cache - Data was found in the page source*/
                this.fetchFeaturesViaCache();
                WPGMZA_CACHE.markers.info.source = "cache";
            }
        }
	}

    WPGMZA.Map.prototype.fetchFeaturesViaCache = function(){
        const mapIds = [parseInt(this.id)];
        if(this.mashupIDs && this.mashupIDs.length){
            for(let id of this.mashupIDs){
                mapIds.push(parseInt(id));
            }
        }

        let cachedData = [];
        for(let mapId of mapIds){
            if(typeof WPGMZA_CACHE.markers.data[mapId] !== 'undefined'){
                cachedData = cachedData.concat(WPGMZA_CACHE.markers.data[mapId]);
            }
        }

        this.onMarkersFetched(cachedData, false);

        var self = this;
        var data;
        var filter = this.markerFilter.getFilteringParameters();
        
        data = this.getRESTParameters({
            filter: JSON.stringify(filter)
        });

        data.exclude = "markers";
        WPGMZA.restAPI.call("/features/", {
            useCompressedPathVariable: true,
            data: data,
            success: function(result, status, xhr) {
                self.onFeaturesFetched(result);
            }
        });
    }
})