<?php

class GMWDMap {
	////////////////////////////////////////////////////////////////////////////////////////
	// Events                                                                             //
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
	// Constants                                                                          //
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
	// Variables                                                                          //
	////////////////////////////////////////////////////////////////////////////////////////
	
	public $version = "3.22";
	public $key = "";
	public $map_uri;
	public $language;
	public $callback;
	public $libraries;

	////////////////////////////////////////////////////////////////////////////////////////
	// Constructor & Destructor                                                           //
	////////////////////////////////////////////////////////////////////////////////////////
	
	public function __construct($callback = "", $language = "en", $version = "3.22" , $key = "", $libraries = "") {
		$this->language = $language;
		$this->version = $version;
		$this->key = $key;
		$this->callback = $callback;

		$map_uri = "http://maps.google.com/maps/api/js";
		if($callback != ""){
			$map_uri = add_query_arg(array( "callback" => $callback ),$map_uri);
		}

		if($key != ""){
			$map_uri = add_query_arg(array( "key" => $key ),$map_uri);
		}
		
		if($libraries != ""){
			$map_uri = add_query_arg(array( "libraries" => $libraries ),$map_uri);
		}

		$map_uri = add_query_arg(array("v"=>$this->version, "language"=>$this->language ),$map_uri);
		$this->map_uri = $map_uri;

	}


	////////////////////////////////////////////////////////////////////////////////////////
	// Public Methods                                                                     //
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
	// Getters & Setters                                                                  //
	////////////////////////////////////////////////////////////////////////////////////////

	////////////////////////////////////////////////////////////////////////////////////////
	// Private Methods                                                                    //
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
	// Listeners                                                                          //
	////////////////////////////////////////////////////////////////////////////////////////
}